<?php
/**
 * Testimonials API Test Helper
 * Use this file to test if the testimonials API is working correctly
 * 
 * Access this file: localhost/path/test_testimonials.php
 */

require_once 'config.php';
session_start();

?>
<!DOCTYPE html>
<html>
<head>
    <title>Testimonials API Test</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            max-width: 900px;
            margin: 50px auto;
            padding: 20px;
            background: #f5f5f5;
        }
        .container {
            background: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        h1 { color: #333; }
        .test-section {
            margin: 20px 0;
            padding: 15px;
            background: #f9f9f9;
            border-left: 4px solid #4facfe;
            border-radius: 4px;
        }
        .button {
            background: #4facfe;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
        }
        .button:hover {
            background: #3a9bd4;
        }
        .response {
            background: #f0f0f0;
            padding: 15px;
            margin-top: 10px;
            border-radius: 4px;
            
            white-space: pre-wrap;
            word-wrap: break-word;
            font-family: monospace;
            font-size: 12px;
            max-height: 400px;
            overflow-y: auto;
        }
        .success { color: #27ae60; }
        .error { color: #e74c3c; }
        .info { color: #3498db; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🧪 Testimonials API Test</h1>
        
        <div class="test-section">
            <h2>Test 1: Check Reviews Table</h2>
            <p>Verify reviews table exists and has data</p>
            <button class="button" onclick="testReviewsTable()">Test Database</button>
            <div id="test1-result" class="response" style="display:none;"></div>
        </div>

        <div class="test-section">
            <h2>Test 2: Check Approved Reviews Count</h2>
            <p>Count how many approved reviews exist</p>
            <button class="button" onclick="testApprovedCount()">Count Approved</button>
            <div id="test2-result" class="response" style="display:none;"></div>
        </div>

        <div class="test-section">
            <h2>Test 3: API Endpoint - Get Approved Reviews</h2>
            <p>Call the actual API endpoint that testimonials use</p>
            <button class="button" onclick="testAPIEndpoint()">Test API</button>
            <div id="test3-result" class="response" style="display:none;"></div>
        </div>

        <div class="test-section">
            <h2>Test 4: View All Reviews (Including Pending)</h2>
            <p>See all reviews regardless of status</p>
            <button class="button" onclick="testAllReviews()">View All</button>
            <div id="test4-result" class="response" style="display:none;"></div>
        </div>

        <div class="test-section">
            <h2>System Status</h2>
            <div id="status">
                <p><span class="info">ℹ</span> Click any test button above to check system status</p>
            </div>
        </div>
    </div>

    <script>
        function showResult(elementId, data, type = 'info') {
            const element = document.getElementById(elementId);
            element.style.display = 'block';
            element.className = 'response ' + type;
            element.innerHTML = typeof data === 'string' ? data : JSON.stringify(data, null, 2);
        }

        function testReviewsTable() {
            fetch('api_handler.php?action=test_reviews_table')
                .then(r => r.json())
                .then(data => {
                    if (data.success) {
                        showResult('test1-result', '✓ Reviews table exists\n\n' + JSON.stringify(data, null, 2), 'success');
                    } else {
                        showResult('test1-result', '✗ ' + data.message, 'error');
                    }
                })
                .catch(e => showResult('test1-result', '✗ Error: ' + e.message, 'error'));
        }

        function testApprovedCount() {
            fetch('api_handler.php?action=test_approved_count')
                .then(r => r.json())
                .then(data => {
                    if (data.success) {
                        const count = data.data.count;
                        const type = count > 0 ? 'success' : 'info';
                        showResult('test2-result', `✓ Approved Reviews: ${count}\n\n${JSON.stringify(data, null, 2)}`, type);
                    } else {
                        showResult('test2-result', '✗ ' + data.message, 'error');
                    }
                })
                .catch(e => showResult('test2-result', '✗ Error: ' + e.message, 'error'));
        }

        function testAPIEndpoint() {
            fetch('api_handler.php?action=get_approved_reviews')
                .then(r => r.json())
                .then(data => {
                    const resultStr = JSON.stringify(data, null, 2);
                    if (data.success && data.data.length > 0) {
                        showResult('test3-result', '✓ API Working!\n\n' + resultStr, 'success');
                    } else if (data.success && data.data.length === 0) {
                        showResult('test3-result', 'ℹ API Working (No approved reviews yet)\n\n' + resultStr, 'info');
                    } else {
                        showResult('test3-result', '✗ API Error\n\n' + resultStr, 'error');
                    }
                })
                .catch(e => showResult('test3-result', '✗ Error: ' + e.message, 'error'));
        }

        function testAllReviews() {
            fetch('api_handler.php?action=test_all_reviews')
                .then(r => r.json())
                .then(data => {
                    if (data.success) {
                        const total = data.data.total;
                        const approved = data.data.approved;
                        const pending = data.data.pending;
                        const result = `✓ Total Reviews: ${total}\n  - Approved: ${approved}\n  - Pending: ${pending}\n\n${JSON.stringify(data.data.reviews, null, 2)}`;
                        showResult('test4-result', result, total > 0 ? 'success' : 'info');
                    } else {
                        showResult('test4-result', '✗ ' + data.message, 'error');
                    }
                })
                .catch(e => showResult('test4-result', '✗ Error: ' + e.message, 'error'));
        }

        // Auto-run all tests on page load
        window.addEventListener('load', function() {
            console.log('Test page loaded');
        });
    </script>
</body>
</html>
